# -*- coding: utf-8 -*-
# This file is part of CAT-SOOP
# Copyright (c) 2011-2023 by The CAT-SOOP Developers <catsoop-dev@mit.edu>
#
# This program is free software: you can redistribute it and/or modify it under
# the terms of the GNU Affero General Public License as published by the Free
# Software Foundation, either version 3 of the License, or (at your option) any
# later version.
#
# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
# FOR A PARTICULAR PURPOSE.  See the GNU Affero General Public License for more
# details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
"""
Mapping from emoji names to unicode code points

Auto-generated from a mapping from [Zulip](https://github.com/zulip/zulip).
"""

EMOJI_MAP = {
    "+1": "👍",
    "-1": "👎",
    "100": "💯",
    "1234": "🔢",
    "8_ball": "🎱",
    "a": "🅰",
    "ab": "🆎",
    "abacus": "🧮",
    "abc": "🔤",
    "abcd": "🔡",
    "absentminded": "😶\u200d🌫",
    "absorbing": "🧽",
    "accept": "🉑",
    "accessible": "♿",
    "accommodations": "🛌",
    "accordion": "🪗",
    "accounting": "🧾",
    "acrobatics": "🤸",
    "action": "🎬",
    "add": "➕",
    "adhesive_bandage": "🩹",
    "adore": "🥰",
    "aerial_tramway": "🚡",
    "aesculapius": "⚕",
    "agent": "🕵",
    "agony": "😖",
    "airplane": "✈",
    "airplane_arrival": "🛬",
    "airplane_departure": "🛫",
    "alarm": "🐓",
    "alarm_clock": "⏰",
    "alchemy": "⚗",
    "alembic": "⚗",
    "alert": "🚨",
    "alien": "👽",
    "all_good": "✅",
    "alpaca": "🦙",
    "alphabet": "🔡",
    "amazement": "🫢",
    "ambulance": "🚑",
    "american_football": "🏈",
    "amoeba": "🦠",
    "amphora": "🏺",
    "amulet": "🪬",
    "amusement_park": "🛝",
    "anatomical": "🫀",
    "anatomical_heart": "🫀",
    "anchor": "⚓",
    "android": "📱",
    "angel": "👼",
    "anger": "💢",
    "anger_bubble": "🗯",
    "angry": "😠",
    "angry_cat": "😾",
    "angry_devil": "👿",
    "anguish": "😫",
    "anguished": "😧",
    "annelid": "🪱",
    "ant": "🐜",
    "anxious": "😬",
    "ape": "🦧",
    "applause": "👏",
    "apple": "🍎",
    "approved": "✅",
    "aquarius": "♒",
    "arabian_camel": "🐪",
    "arcade": "🕹",
    "archery": "🏹",
    "archive": "🗃",
    "arctic": "🐻\u200d❄",
    "arepa": "🫓",
    "aries": "♈",
    "arms_open": "🤗",
    "army": "🪖",
    "arrival": "🛬",
    "art": "🎨",
    "artist": "🧑\u200d🎨",
    "asking_a_question": "☝",
    "assistance": "🐕\u200d🦺",
    "asterisk": "*⃣",
    "astonished": "😲",
    "astronaut": "🧑\u200d🚀",
    "at_work": "⚒",
    "athletic_shoe": "👟",
    "atm": "🏧",
    "atom": "⚛",
    "attachment": "📎",
    "attraction": "🧲",
    "auto_rickshaw": "🛺",
    "autumn": "🥮",
    "avocado": "🥑",
    "awe": "🫢",
    "axe": "🪓",
    "b": "🅱",
    "baa": "🐑",
    "baby": "👶",
    "baby_bottle": "🍼",
    "baby_change_station": "🚼",
    "baby_chick": "🐤",
    "back": "🔙",
    "backpack": "🎒",
    "backpacking": "🥾",
    "bacon": "🥓",
    "badger": "🦡",
    "badminton": "🏸",
    "bagel": "🥯",
    "baggage_claim": "🛄",
    "baguette": "🥖",
    "bait": "🪤",
    "balance": "⚖",
    "ball": "⛹",
    "ballet": "🩰",
    "ballet_flat": "🥿",
    "ballet_shoes": "🩰",
    "balloon": "🎈",
    "ballot_box": "🗳",
    "ballpoint_pen": "🖊",
    "bam": "💢",
    "bamboo": "🎍",
    "banana": "🍌",
    "bandage": "🩹",
    "bangbang": "‼",
    "banjo": "🪕",
    "bank": "🏦",
    "bar": "🧼",
    "bar_chart": "📊",
    "barber": "💈",
    "baseball": "⚾",
    "baseball_cap": "🧢",
    "basket": "🧺",
    "basketball": "🏀",
    "bat": "🦇",
    "bath": "🛀",
    "bathing": "🧼",
    "bathroom": "🪥",
    "bathtub": "🛁",
    "battery": "🔋",
    "beach": "🏖",
    "beach_sandals": "🩴",
    "beach_umbrella": "⛱",
    "bead": "🧿",
    "beans": "🫘",
    "bear": "🐻",
    "beat": "🪘",
    "beaver": "🦫",
    "beckon": "🫴",
    "bed": "🛏",
    "bedroom": "🛏",
    "bee": "🐝",
    "beer": "🍺",
    "beers": "🍻",
    "beetle": "🪲",
    "begging": "🥺",
    "beginner": "🔰",
    "bell": "🔔",
    "bell_pepper": "🫑",
    "bellhop_bell": "🛎",
    "bento": "🍱",
    "berry": "🫐",
    "betrayed": "🔪",
    "beverage": "🧃",
    "beverage_box": "🧃",
    "bicycle": "🚲",
    "big_frown": "☹",
    "big_rig": "🚛",
    "big_smile": "😄",
    "bike": "🚲",
    "bikini": "👙",
    "bilberry": "🫐",
    "billed_cap": "🧢",
    "billiards": "🎱",
    "biohazard": "☣",
    "biology": "🧫",
    "bird": "🐦",
    "birthday": "🎂",
    "bison": "🦬",
    "bisque": "🦞",
    "biting_lip": "🫦",
    "black": "🐈\u200d⬛",
    "black_and_white_square": "🔳",
    "black_belt": "🥋",
    "black_cat": "🐈\u200d⬛",
    "black_circle": "⚫",
    "black_flag": "🏴",
    "black_heart": "🖤",
    "black_large_square": "⬛",
    "black_medium_small_square": "◾",
    "black_medium_square": "◼",
    "black_nib": "✒",
    "black_small_square": "▪",
    "blank": "😶",
    "bleed": "🩸",
    "blond_haired_man": "👱\u200d♂",
    "blond_haired_person": "👱",
    "blond_haired_woman": "👱\u200d♀",
    "blonde": "👱\u200d♀",
    "blood_donation": "🩸",
    "blossom": "🌼",
    "blow_a_kiss": "😘",
    "blowfish": "🐡",
    "blue_book": "📘",
    "blue_circle": "🔵",
    "blue_faced": "🥶",
    "blue_heart": "💙",
    "blue_square": "🟦",
    "blueberries": "🫐",
    "blueberry": "🫐",
    "blush": "😊",
    "blushing": "😳",
    "boar": "🐗",
    "board": "🛹",
    "boat": "⛵",
    "bok_choy": "🥬",
    "bomb": "💣",
    "bone": "🦴",
    "bones": "🩻",
    "boo": "👻",
    "book": "📖",
    "bookkeeping": "🧾",
    "bookmark": "🔖",
    "books": "📚",
    "boom": "💥",
    "boomerang": "🪃",
    "boot": "👢",
    "bored": "🥱",
    "boring": "🪴",
    "boulder": "🪨",
    "bouquet": "💐",
    "bow": "🙇",
    "bow_and_arrow": "🏹",
    "bowl_with_spoon": "🥣",
    "bowling": "🎳",
    "box": "🧃",
    "boxing_glove": "🥊",
    "boy": "👦",
    "brachiosaurus": "🦕",
    "brain": "🧠",
    "bravery": "💜",
    "bread": "🍞",
    "breakfast": "🥞",
    "breast": "🤱",
    "breast_feeding": "🤱",
    "breath": "🫁",
    "brick": "🧱",
    "bricks": "🧱",
    "bride": "👰",
    "bridge": "🌉",
    "briefcase": "💼",
    "briefs": "🩲",
    "brightness": "🔆",
    "broccoli": "🥦",
    "broken_heart": "💔",
    "brontosaurus": "🦕",
    "bronze": "🥉",
    "broom": "🧹",
    "brown_circle": "🟤",
    "brown_heart": "🤎",
    "brown_square": "🟫",
    "brush": "🪥",
    "bubble_tea": "🧋",
    "bubbles": "🫧",
    "bucket": "🪣",
    "buddhism": "☸",
    "buffalo": "🦬",
    "bug": "🐛",
    "bulb": "💡",
    "bull": "🐂",
    "bullet_train": "🚅",
    "bullhorn": "📢",
    "bulls_eye": "🎯",
    "bunny": "🐰",
    "burial": "⚰",
    "burn": "❤\u200d🔥",
    "burp": "🫧",
    "burrito": "🌯",
    "bus": "🚌",
    "bus_stop": "🚏",
    "butter": "🧈",
    "butterfly": "🦋",
    "buzz": "🐝",
    "c": "©",
    "cabbage": "🥬",
    "cactus": "🌵",
    "cake": "🍰",
    "calculation": "🧮",
    "calendar": "📅",
    "calf": "🐮",
    "call_me": "🤙",
    "calling": "📲",
    "camel": "🐫",
    "camera": "📷",
    "camping": "⛺",
    "campsite": "🏕",
    "can": "🥫",
    "cancer": "♋",
    "candle": "🕯",
    "candy": "🍬",
    "cane": "🩼",
    "canned_food": "🥫",
    "canoe": "🛶",
    "capital_abcd": "🔠",
    "capital_letters": "🔠",
    "capricorn": "♑",
    "capsicum": "🫑",
    "captivated": "🫣",
    "car": "🚗",
    "card_index": "📇",
    "cardiology": "🫀",
    "carousel": "🎠",
    "carp_streamer": "🎏",
    "carpenter": "🪚",
    "carpenter_square": "📐",
    "carpentry_saw": "🪚",
    "carrot": "🥕",
    "cartwheel": "🤸",
    "cask": "🪣",
    "castle": "🏰",
    "cat": "🐈",
    "caterpillar": "🐛",
    "caution": "⚠",
    "cd": "💿",
    "celebration": "🎈",
    "cell_reception": "📶",
    "cemetery": "🪦",
    "cereal": "🥣",
    "chains": "⛓",
    "chair": "🪑",
    "champagne": "🍾",
    "charm": "🧿",
    "chart": "📈",
    "check": "✅",
    "check_mark": "✔",
    "checkbox": "☑",
    "checkered_flag": "🏁",
    "cheese": "🧀",
    "chemistry": "🧪",
    "cherries": "🍒",
    "cherry_blossom": "🌸",
    "chess": "♟",
    "chess_pawn": "♟",
    "chest": "🧰",
    "chestnut": "🌰",
    "chick": "🐤",
    "chicken": "🐔",
    "chickpea": "🧆",
    "child": "🧒",
    "children_crossing": "🚸",
    "chili_pepper": "🌶",
    "chipmunk": "🐿",
    "chocolate": "🍫",
    "chopsticks": "🥢",
    "christianity": "✝",
    "church": "⛪",
    "cinema": "🎦",
    "circle": "⭕",
    "circus": "🎪",
    "city": "🏙",
    "city_sunrise": "🌇",
    "cl": "🆑",
    "clap": "👏",
    "classical_building": "🏛",
    "claus_christmas": "🧑\u200d🎄",
    "claws": "🦞",
    "clay": "🧱",
    "climb": "🪜",
    "clink": "🥂",
    "clipboard": "📋",
    "clock": "🕗",
    "clockwise": "🔃",
    "closed_book": "📕",
    "closed_mailbox": "📪",
    "closed_umbrella": "🌂",
    "clothing": "👚",
    "cloud": "☁",
    "cloudy": "🌥",
    "clover": "☘",
    "clown": "🤡",
    "clubs": "♣",
    "cluck": "🐔",
    "clue": "🗝",
    "coat": "🧥",
    "cock-a-doodle-doo": "🐓",
    "cockroach": "🪳",
    "cocktail": "🍸",
    "coconut": "🥥",
    "coffee": "☕",
    "coffin": "⚰",
    "coin": "🪙",
    "cold_face": "🥶",
    "cold_sweat": "😰",
    "collision": "💥",
    "come": "🫴",
    "comet": "☄",
    "commitment": "🔐",
    "commodities": "🛢",
    "compass": "🧭",
    "composition_book": "📓",
    "compression": "🗜",
    "computer": "💻",
    "computer_mouse": "🖱",
    "concerned": "😕",
    "concertina": "🪗",
    "conch": "🐚",
    "condemned": "🏚",
    "confetti": "🎊",
    "confounded": "😖",
    "confused": "😕",
    "conga": "🪘",
    "congee": "🥣",
    "congratulations": "㊗",
    "construction": "🏗",
    "construction_worker": "👷",
    "construction_zone": "🚧",
    "container": "🫙",
    "control_knobs": "🎛",
    "convenience_store": "🏪",
    "cook": "🧑\u200d🍳",
    "cookie": "🍪",
    "cooking": "🍳",
    "cool": "🆒",
    "cop": "👮",
    "copyright": "©",
    "coral": "🪸",
    "corn": "🌽",
    "couch_and_lamp": "🛋",
    "counterclockwise": "🔄",
    "couple_with_heart": "💑",
    "couple_with_heart_man_man": "👨\u200d❤\u200d👨",
    "couple_with_heart_woman_man": "👩\u200d❤\u200d👨",
    "couple_with_heart_woman_woman": "👩\u200d❤\u200d👩",
    "cow": "🐄",
    "cowboy": "🤠",
    "crab": "🦀",
    "crash": "💥",
    "crayon": "🖍",
    "crazy": "😜",
    "credentials": "🪪",
    "credit_card": "💳",
    "cremation": "⚱",
    "crew": "🚣",
    "cricket": "🦗",
    "cricket_game": "🏏",
    "crochet": "🧶",
    "crocodile": "🐊",
    "croissant": "🥐",
    "crook": "🪝",
    "cross": "✝",
    "cross_mark": "❌",
    "crossed_flags": "🎌",
    "crown": "👑",
    "cruise": "🛳",
    "crush": "🥰",
    "crushed": "🥀",
    "crutch": "🩼",
    "cry": "😢",
    "crying_cat": "😿",
    "crystal": "💎",
    "crystal_ball": "🔮",
    "cucumber": "🥒",
    "culture": "🧫",
    "cup_with_straw": "🥤",
    "cupcake": "🧁",
    "cupid": "💘",
    "curious": "🦝",
    "curl": "📃",
    "curling_stone": "🥌",
    "curry": "🍛",
    "curve": "🪝",
    "custard": "🍮",
    "customs": "🛃",
    "cut_of_meat": "🥩",
    "cute": "💠",
    "cyclist": "🚴",
    "cyclone": "🌀",
    "cygnet": "🦢",
    "dagger": "🗡",
    "dairy": "🧈",
    "dam": "🦫",
    "dancer": "💃",
    "dancers": "👯",
    "dancing": "🕺",
    "danger": "⚠",
    "dango": "🍡",
    "dark_sunglasses": "🕶",
    "darts": "🎯",
    "dash": "💨",
    "date": "📆",
    "deaf_man": "🧏\u200d♂",
    "deaf_person": "🧏",
    "deaf_woman": "🧏\u200d♀",
    "death": "☠",
    "debit_card": "💳",
    "deciduous_tree": "🌳",
    "decoration": "🎀",
    "decorative_notebook": "📔",
    "decrease": "🔽",
    "decreasing": "📉",
    "deer": "🦌",
    "demonstration": "🪧",
    "denim": "👖",
    "dental": "🪥",
    "dentist": "🦷",
    "department_store": "🏬",
    "departure": "🛫",
    "depressed": "🫥",
    "derelict_house": "🏚",
    "desert": "🏜",
    "desktop_computer": "🖥",
    "detective": "🕵",
    "devil": "👿",
    "diamond_with_a_dot": "💠",
    "diamonds": "♦",
    "diaper": "🧷",
    "dice": "🎲",
    "die": "🎲",
    "digital_security": "🔏",
    "dim": "🔅",
    "ding": "🛎",
    "diplodocus": "🦕",
    "direct_hit": "🎯",
    "disability": "🩼",
    "disabled": "♿",
    "disappointed": "😞",
    "disappointed_relieved": "😥",
    "disco": "🕺",
    "disguise": "🥸",
    "disguised_face": "🥸",
    "dismiss": "🫳",
    "dissolve": "🫠",
    "distraught": "😩",
    "distrust": "🤨",
    "divide": "➗",
    "diving_mask": "🤿",
    "division": "➗",
    "diya": "🪔",
    "diya_lamp": "🪔",
    "dizzy": "😵",
    "dna": "🧬",
    "do_not_litter": "🚯",
    "document": "📄",
    "dodo": "🦤",
    "dog": "🐕",
    "dogi": "🥋",
    "doll": "🪆",
    "dollar_bills": "💵",
    "dollars": "💲",
    "dolls": "🎎",
    "dolphin": "🐬",
    "done_deal": "🤝",
    "doner_kebab": "🥙",
    "donut": "🍩",
    "door": "🚪",
    "dormouse": "🐭",
    "dotted_line_face": "🫥",
    "dotted_six_pointed_star": "🔯",
    "double_down": "⏬",
    "double_exclamation": "‼",
    "double_loop": "➿",
    "double_up": "⏫",
    "doughnut": "🍩",
    "dove": "🕊",
    "dove_of_peace": "🕊",
    "down": "⬇",
    "down_button": "🔽",
    "downvote": "🔽",
    "downwards_trend": "📉",
    "dragon": "🐉",
    "dragon_face": "🐲",
    "drama": "🎭",
    "dream": "💭",
    "drenched": "🌧",
    "dress": "👗",
    "drinking_water": "🚰",
    "drive_with_care": "🚸",
    "drooling": "🤤",
    "drop": "💧",
    "drop_of_blood": "🩸",
    "drum": "🥁",
    "drumstick": "🍗",
    "duck": "🦆",
    "duel": "⚔",
    "dumpling": "🥟",
    "dungeon": "🗝",
    "dupe": "♟",
    "dvd": "📀",
    "dynamite": "🧨",
    "e-mail": "📧",
    "eagle": "🦅",
    "ear": "👂",
    "ear_of_rice": "🌾",
    "ear_with_hearing_aid": "🦻",
    "earth_africa": "🌍",
    "earth_americas": "🌎",
    "earth_asia": "🌏",
    "earthworm": "🪱",
    "east": "➡",
    "easy_come_easy_go": "💸",
    "eating_utensils": "🍴",
    "egg": "🥚",
    "eggplant": "🍆",
    "eight": "8⃣",
    "eight_pointed_star": "✴",
    "eight_spoked_asterisk": "✳",
    "eject": "⏏",
    "eject_button": "⏏",
    "elderly_man": "👴",
    "elderly_woman": "👵",
    "electric_plug": "🔌",
    "electronic": "🪫",
    "elephant": "🐘",
    "elevated_train": "🚝",
    "elevator": "🛗",
    "elf": "🧝",
    "email": "✉",
    "embarrass": "🫢",
    "embarrassed": "😳",
    "embroidery": "🪡",
    "emergency": "🦺",
    "empanada": "🥟",
    "empty_mailbox": "📭",
    "empty_nest": "🪹",
    "encrypted": "🗝",
    "end": "🔚",
    "engineer": "⚙",
    "ensnare": "🪝",
    "envelope": "✉",
    "envy": "💚",
    "equality": "🟰",
    "euro_banknotes": "💶",
    "evergreen_tree": "🌲",
    "evidence": "🧾",
    "evil_eye": "🧿",
    "evolution": "🧬",
    "exchange": "💱",
    "exclamation": "❗",
    "exhalation": "🫁",
    "exhale": "😮\u200d💨",
    "exhausted": "😥",
    "expecting": "🤰",
    "expendable": "♟",
    "expensive": "🫰",
    "exploding_head": "🤯",
    "explosion": "💥",
    "explosive": "🧨",
    "expressionless": "😑",
    "extinguish": "🧯",
    "eye": "👁",
    "eye_in_speech_bubble": "👁️\u200d🗨️",
    "eye_protection": "🥽",
    "eyes": "👀",
    "face_exhaling": "😮\u200d💨",
    "face_holding_back_tears": "🥹",
    "face_in_clouds": "😶\u200d🌫",
    "face_in_the_fog": "😶\u200d🌫",
    "face_palm": "🤦",
    "face_vomiting": "🤮",
    "face_with_diagonal_mouth": "🫤",
    "face_with_hand_over_mouth": "🤭",
    "face_with_monocle": "🧐",
    "face_with_open_eyes_and_hand_over_mouth": "🫢",
    "face_with_peeking_eye": "🫣",
    "face_with_raised_eyebrow": "🤨",
    "face_with_spiral_eyes": "😵\u200d💫",
    "face_with_symbols_on_mouth": "🤬",
    "face_with_thermometer": "🤒",
    "factory": "🏭",
    "factory_worker": "🧑\u200d🏭",
    "fairy": "🧚",
    "fairy_tale": "🧌",
    "falafel": "🧆",
    "fall": "🍃",
    "fallen_leaf": "🍂",
    "family": "👪",
    "family_man_boy": "👨\u200d👦",
    "family_man_boy_boy": "👨\u200d👦\u200d👦",
    "family_man_girl": "👨\u200d👧",
    "family_man_girl_boy": "👨\u200d👧\u200d👦",
    "family_man_girl_girl": "👨\u200d👧\u200d👧",
    "family_man_man_boy": "👨\u200d👨\u200d👦",
    "family_man_man_boy_boy": "👨\u200d👨\u200d👦\u200d👦",
    "family_man_man_girl": "👨\u200d👨\u200d👧",
    "family_man_man_girl_boy": "👨\u200d👨\u200d👧\u200d👦",
    "family_man_man_girl_girl": "👨\u200d👨\u200d👧\u200d👧",
    "family_man_woman_boy": "👨\u200d👩\u200d👦",
    "family_man_woman_boy_boy": "👨\u200d👩\u200d👦\u200d👦",
    "family_man_woman_girl": "👨\u200d👩\u200d👧",
    "family_man_woman_girl_boy": "👨\u200d👩\u200d👧\u200d👦",
    "family_man_woman_girl_girl": "👨\u200d👩\u200d👧\u200d👧",
    "family_woman_boy": "👩\u200d👦",
    "family_woman_boy_boy": "👩\u200d👦\u200d👦",
    "family_woman_girl": "👩\u200d👧",
    "family_woman_girl_boy": "👩\u200d👧\u200d👦",
    "family_woman_girl_girl": "👩\u200d👧\u200d👧",
    "family_woman_woman_boy": "👩\u200d👩\u200d👦",
    "family_woman_woman_boy_boy": "👩\u200d👩\u200d👦\u200d👦",
    "family_woman_woman_girl": "👩\u200d👩\u200d👧",
    "family_woman_woman_girl_boy": "👩\u200d👩\u200d👧\u200d👦",
    "family_woman_woman_girl_girl": "👩\u200d👩\u200d👧\u200d👧",
    "fantasy": "🧌",
    "farmer": "🧑\u200d🌾",
    "farming": "🧺",
    "fast_down": "⏬",
    "fast_forward": "⏩",
    "fast_reverse": "⏪",
    "fast_up": "⏫",
    "fatima": "🪬",
    "fax": "📠",
    "fear": "😨",
    "feather": "🪶",
    "feet": "👣",
    "female_sign": "♀",
    "fencing": "🤺",
    "ferris_wheel": "🎡",
    "ferry": "⛴",
    "festival": "🥮",
    "fever": "🤒",
    "feverish": "🥵",
    "field_hockey": "🏑",
    "fighter": "🥷",
    "file": "📄",
    "file_cabinet": "🗄",
    "file_folder": "📁",
    "filling": "🥧",
    "film": "🎞",
    "find": "🔍",
    "fingers": "🤌",
    "fingers_crossed": "🤞",
    "fire": "🔥",
    "fire_engine": "🚒",
    "fire_extinguisher": "🧯",
    "fire_truck": "🚒",
    "firecracker": "🧨",
    "firefighter": "🧑\u200d🚒",
    "fireworks": "🎆",
    "first_place": "🥇",
    "first_quarter_moon": "🌓",
    "fish": "🐟",
    "fishing": "🎣",
    "fist": "✊",
    "fist_bump": "👊",
    "five": "5⃣",
    "fixing": "🔧",
    "flag_afghanistan": "🇦🇫",
    "flag_aland_islands": "🇦🇽",
    "flag_albania": "🇦🇱",
    "flag_algeria": "🇩🇿",
    "flag_american_samoa": "🇦🇸",
    "flag_andorra": "🇦🇩",
    "flag_angola": "🇦🇴",
    "flag_anguilla": "🇦🇮",
    "flag_antarctica": "🇦🇶",
    "flag_antigua_and_barbuda": "🇦🇬",
    "flag_argentina": "🇦🇷",
    "flag_armenia": "🇦🇲",
    "flag_aruba": "🇦🇼",
    "flag_ascension_island": "🇦🇨",
    "flag_australia": "🇦🇺",
    "flag_austria": "🇦🇹",
    "flag_azerbaijan": "🇦🇿",
    "flag_bahamas": "🇧🇸",
    "flag_bahrain": "🇧🇭",
    "flag_bangladesh": "🇧🇩",
    "flag_barbados": "🇧🇧",
    "flag_belarus": "🇧🇾",
    "flag_belgium": "🇧🇪",
    "flag_belize": "🇧🇿",
    "flag_benin": "🇧🇯",
    "flag_bermuda": "🇧🇲",
    "flag_bhutan": "🇧🇹",
    "flag_bolivia": "🇧🇴",
    "flag_bosnia_and_herzegovina": "🇧🇦",
    "flag_botswana": "🇧🇼",
    "flag_bouvet_island": "🇧🇻",
    "flag_brazil": "🇧🇷",
    "flag_british_indian_ocean_territory": "🇮🇴",
    "flag_british_virgin_islands": "🇻🇬",
    "flag_brunei": "🇧🇳",
    "flag_bulgaria": "🇧🇬",
    "flag_burkina_faso": "🇧🇫",
    "flag_burundi": "🇧🇮",
    "flag_cambodia": "🇰🇭",
    "flag_cameroon": "🇨🇲",
    "flag_canada": "🇨🇦",
    "flag_canary_islands": "🇮🇨",
    "flag_cape_verde": "🇨🇻",
    "flag_caribbean_netherlands": "🇧🇶",
    "flag_cayman_islands": "🇰🇾",
    "flag_central_african_republic": "🇨🇫",
    "flag_ceuta_and_melilla": "🇪🇦",
    "flag_chad": "🇹🇩",
    "flag_chile": "🇨🇱",
    "flag_china": "🇨🇳",
    "flag_christmas_island": "🇨🇽",
    "flag_clipperton_island": "🇨🇵",
    "flag_cocos_keeling_islands": "🇨🇨",
    "flag_colombia": "🇨🇴",
    "flag_comoros": "🇰🇲",
    "flag_congo_brazzaville": "🇨🇬",
    "flag_congo_kinshasa": "🇨🇩",
    "flag_cook_islands": "🇨🇰",
    "flag_costa_rica": "🇨🇷",
    "flag_cote_divoire": "🇨🇮",
    "flag_croatia": "🇭🇷",
    "flag_cuba": "🇨🇺",
    "flag_curacao": "🇨🇼",
    "flag_curaçao": "🇨🇼",
    "flag_cyprus": "🇨🇾",
    "flag_czechia": "🇨🇿",
    "flag_côte_divoire": "🇨🇮",
    "flag_denmark": "🇩🇰",
    "flag_diego_garcia": "🇩🇬",
    "flag_djibouti": "🇩🇯",
    "flag_dominica": "🇩🇲",
    "flag_dominican_republic": "🇩🇴",
    "flag_ecuador": "🇪🇨",
    "flag_egypt": "🇪🇬",
    "flag_el_salvador": "🇸🇻",
    "flag_england": "🏴\U000e0067\U000e0062\U000e0065\U000e006e\U000e0067\U000e007f",
    "flag_equatorial_guinea": "🇬🇶",
    "flag_eritrea": "🇪🇷",
    "flag_estonia": "🇪🇪",
    "flag_eswatini": "🇸🇿",
    "flag_ethiopia": "🇪🇹",
    "flag_european_union": "🇪🇺",
    "flag_falkland_islands": "🇫🇰",
    "flag_faroe_islands": "🇫🇴",
    "flag_fiji": "🇫🇯",
    "flag_finland": "🇫🇮",
    "flag_france": "🇫🇷",
    "flag_french_guiana": "🇬🇫",
    "flag_french_polynesia": "🇵🇫",
    "flag_french_southern_territories": "🇹🇫",
    "flag_gabon": "🇬🇦",
    "flag_gambia": "🇬🇲",
    "flag_georgia": "🇬🇪",
    "flag_germany": "🇩🇪",
    "flag_ghana": "🇬🇭",
    "flag_gibraltar": "🇬🇮",
    "flag_greece": "🇬🇷",
    "flag_greenland": "🇬🇱",
    "flag_grenada": "🇬🇩",
    "flag_guadeloupe": "🇬🇵",
    "flag_guam": "🇬🇺",
    "flag_guatemala": "🇬🇹",
    "flag_guernsey": "🇬🇬",
    "flag_guinea": "🇬🇳",
    "flag_guinea_bissau": "🇬🇼",
    "flag_guyana": "🇬🇾",
    "flag_haiti": "🇭🇹",
    "flag_heard_and_mcdonald_islands": "🇭🇲",
    "flag_honduras": "🇭🇳",
    "flag_hong_kong_sar_china": "🇭🇰",
    "flag_hungary": "🇭🇺",
    "flag_iceland": "🇮🇸",
    "flag_india": "🇮🇳",
    "flag_indonesia": "🇮🇩",
    "flag_iran": "🇮🇷",
    "flag_iraq": "🇮🇶",
    "flag_ireland": "🇮🇪",
    "flag_isle_of_man": "🇮🇲",
    "flag_israel": "🇮🇱",
    "flag_italy": "🇮🇹",
    "flag_jamaica": "🇯🇲",
    "flag_japan": "🇯🇵",
    "flag_jersey": "🇯🇪",
    "flag_jordan": "🇯🇴",
    "flag_kazakhstan": "🇰🇿",
    "flag_kenya": "🇰🇪",
    "flag_kiribati": "🇰🇮",
    "flag_kosovo": "🇽🇰",
    "flag_kuwait": "🇰🇼",
    "flag_kyrgyzstan": "🇰🇬",
    "flag_laos": "🇱🇦",
    "flag_latvia": "🇱🇻",
    "flag_lebanon": "🇱🇧",
    "flag_lesotho": "🇱🇸",
    "flag_liberia": "🇱🇷",
    "flag_libya": "🇱🇾",
    "flag_liechtenstein": "🇱🇮",
    "flag_lithuania": "🇱🇹",
    "flag_luxembourg": "🇱🇺",
    "flag_macao_sar_china": "🇲🇴",
    "flag_madagascar": "🇲🇬",
    "flag_malawi": "🇲🇼",
    "flag_malaysia": "🇲🇾",
    "flag_maldives": "🇲🇻",
    "flag_mali": "🇲🇱",
    "flag_malta": "🇲🇹",
    "flag_marshall_islands": "🇲🇭",
    "flag_martinique": "🇲🇶",
    "flag_mauritania": "🇲🇷",
    "flag_mauritius": "🇲🇺",
    "flag_mayotte": "🇾🇹",
    "flag_mexico": "🇲🇽",
    "flag_micronesia": "🇫🇲",
    "flag_moldova": "🇲🇩",
    "flag_monaco": "🇲🇨",
    "flag_mongolia": "🇲🇳",
    "flag_montenegro": "🇲🇪",
    "flag_montserrat": "🇲🇸",
    "flag_morocco": "🇲🇦",
    "flag_mozambique": "🇲🇿",
    "flag_myanmar_burma": "🇲🇲",
    "flag_namibia": "🇳🇦",
    "flag_nauru": "🇳🇷",
    "flag_nepal": "🇳🇵",
    "flag_netherlands": "🇳🇱",
    "flag_new_caledonia": "🇳🇨",
    "flag_new_zealand": "🇳🇿",
    "flag_nicaragua": "🇳🇮",
    "flag_niger": "🇳🇪",
    "flag_nigeria": "🇳🇬",
    "flag_niue": "🇳🇺",
    "flag_norfolk_island": "🇳🇫",
    "flag_north_korea": "🇰🇵",
    "flag_north_macedonia": "🇲🇰",
    "flag_northern_mariana_islands": "🇲🇵",
    "flag_norway": "🇳🇴",
    "flag_oman": "🇴🇲",
    "flag_pakistan": "🇵🇰",
    "flag_palau": "🇵🇼",
    "flag_palestinian_territories": "🇵🇸",
    "flag_panama": "🇵🇦",
    "flag_papua_new_guinea": "🇵🇬",
    "flag_paraguay": "🇵🇾",
    "flag_peru": "🇵🇪",
    "flag_philippines": "🇵🇭",
    "flag_pitcairn_islands": "🇵🇳",
    "flag_poland": "🇵🇱",
    "flag_portugal": "🇵🇹",
    "flag_puerto_rico": "🇵🇷",
    "flag_qatar": "🇶🇦",
    "flag_reunion": "🇷🇪",
    "flag_romania": "🇷🇴",
    "flag_russia": "🇷🇺",
    "flag_rwanda": "🇷🇼",
    "flag_réunion": "🇷🇪",
    "flag_samoa": "🇼🇸",
    "flag_san_marino": "🇸🇲",
    "flag_sao_tome_and_principe": "🇸🇹",
    "flag_saudi_arabia": "🇸🇦",
    "flag_scotland": "🏴\U000e0067\U000e0062\U000e0073\U000e0063\U000e0074\U000e007f",
    "flag_senegal": "🇸🇳",
    "flag_serbia": "🇷🇸",
    "flag_seychelles": "🇸🇨",
    "flag_sierra_leone": "🇸🇱",
    "flag_singapore": "🇸🇬",
    "flag_sint_maarten": "🇸🇽",
    "flag_slovakia": "🇸🇰",
    "flag_slovenia": "🇸🇮",
    "flag_solomon_islands": "🇸🇧",
    "flag_somalia": "🇸🇴",
    "flag_south_africa": "🇿🇦",
    "flag_south_georgia_and_south_sandwich_islands": "🇬🇸",
    "flag_south_korea": "🇰🇷",
    "flag_south_sudan": "🇸🇸",
    "flag_spain": "🇪🇸",
    "flag_sri_lanka": "🇱🇰",
    "flag_st_barthelemy": "🇧🇱",
    "flag_st_barthélemy": "🇧🇱",
    "flag_st_helena": "🇸🇭",
    "flag_st_kitts_and_nevis": "🇰🇳",
    "flag_st_lucia": "🇱🇨",
    "flag_st_martin": "🇲🇫",
    "flag_st_pierre_and_miquelon": "🇵🇲",
    "flag_st_vincent_and_grenadines": "🇻🇨",
    "flag_sudan": "🇸🇩",
    "flag_suriname": "🇸🇷",
    "flag_svalbard_and_jan_mayen": "🇸🇯",
    "flag_sweden": "🇸🇪",
    "flag_switzerland": "🇨🇭",
    "flag_syria": "🇸🇾",
    "flag_são_tomé_and_príncipe": "🇸🇹",
    "flag_taiwan": "🇹🇼",
    "flag_tajikistan": "🇹🇯",
    "flag_tanzania": "🇹🇿",
    "flag_thailand": "🇹🇭",
    "flag_timor_leste": "🇹🇱",
    "flag_togo": "🇹🇬",
    "flag_tokelau": "🇹🇰",
    "flag_tonga": "🇹🇴",
    "flag_trinidad_and_tobago": "🇹🇹",
    "flag_tristan_da_cunha": "🇹🇦",
    "flag_tunisia": "🇹🇳",
    "flag_turkey": "🇹🇷",
    "flag_turkmenistan": "🇹🇲",
    "flag_turks_and_caicos_islands": "🇹🇨",
    "flag_tuvalu": "🇹🇻",
    "flag_uganda": "🇺🇬",
    "flag_ukraine": "🇺🇦",
    "flag_united_arab_emirates": "🇦🇪",
    "flag_united_kingdom": "🇬🇧",
    "flag_united_nations": "🇺🇳",
    "flag_united_states": "🇺🇸",
    "flag_uruguay": "🇺🇾",
    "flag_us_outlying_islands": "🇺🇲",
    "flag_us_virgin_islands": "🇻🇮",
    "flag_uzbekistan": "🇺🇿",
    "flag_vanuatu": "🇻🇺",
    "flag_vatican_city": "🇻🇦",
    "flag_venezuela": "🇻🇪",
    "flag_vietnam": "🇻🇳",
    "flag_wales": "🏴\U000e0067\U000e0062\U000e0077\U000e006c\U000e0073\U000e007f",
    "flag_wallis_and_futuna": "🇼🇫",
    "flag_western_sahara": "🇪🇭",
    "flag_yemen": "🇾🇪",
    "flag_zambia": "🇿🇲",
    "flag_zimbabwe": "🇿🇼",
    "flag_åland_islands": "🇦🇽",
    "flags": "🎏",
    "flamboyant": "🦩",
    "flame": "🔥",
    "flamingo": "🦩",
    "flan": "🍮",
    "flashlight": "🔦",
    "flat_shoe": "🥿",
    "flatbread": "🫓",
    "fleur_de_lis": "⚜",
    "flight": "🪶",
    "flip_flops": "👡",
    "flipper": "🐬",
    "flirting": "🫦",
    "float": "🛟",
    "floppy_disk": "💾",
    "flower": "🌷",
    "flu": "🤒",
    "fluctuate": "🪀",
    "flushed": "😳",
    "fly": "🪰",
    "flying_disc": "🥏",
    "flying_saucer": "🛸",
    "fog": "🌫",
    "foggy": "🌁",
    "folder": "📂",
    "fondue": "🫕",
    "food": "🍲",
    "foot": "🦶",
    "football": "⚽",
    "footprints": "👣",
    "force_cup": "🪠",
    "forever": "♾",
    "fork_and_knife": "🍴",
    "fork_and_knife_with_plate": "🍽",
    "fortune": "🔯",
    "fortune_cookie": "🥠",
    "fortune_telling": "🔮",
    "forward": "↪",
    "fountain": "⛲",
    "fountain_pen": "🖋",
    "four": "4⃣",
    "four_leaf_clover": "🍀",
    "fox": "🦊",
    "frame": "🪟",
    "framed_picture": "🖼",
    "free": "🆓",
    "freezing": "🥶",
    "fresh_air": "🪟",
    "fries": "🍟",
    "frog": "🐸",
    "frostbite": "🥶",
    "frosty": "⛄",
    "frown": "🙁",
    "frowning": "😦",
    "fruit": "🥭",
    "fuel_pump": "⛽",
    "full_battery": "🔋",
    "full_moon": "🌕",
    "funeral_urn": "⚱",
    "furniture": "🛋",
    "future": "🔮",
    "garlic": "🧄",
    "gas_pump": "⛽",
    "gasp": "😮\u200d💨",
    "gear": "⚙",
    "gecko": "🦎",
    "geek": "🤓",
    "gelato": "🍨",
    "gem": "💎",
    "gemini": "♊",
    "gene": "🧬",
    "genetics": "🧬",
    "genie": "🧞",
    "ghost": "👻",
    "gibbous": "🌖",
    "gift": "🎁",
    "gift_heart": "💝",
    "giraffe": "🦒",
    "girl": "👧",
    "glamour": "✨",
    "glass_of_milk": "🥛",
    "glasses": "👓",
    "glitter": "🪩",
    "globe": "🌐",
    "glove": "🥎",
    "gloves": "🧤",
    "glowing_star": "🌟",
    "go": "🏁",
    "goal": "🥅",
    "goat": "🐐",
    "goblin": "👺",
    "goggles": "🥽",
    "gold": "🥇",
    "gold_record": "💽",
    "golf": "🏌",
    "gondola": "🚠",
    "good_luck": "🧧",
    "goodbye": "🫂",
    "goodnight": "🌛",
    "goofy": "🤪",
    "gooooooooal": "🥅",
    "gorilla": "🦍",
    "got_it": "👌",
    "graduate": "🎓",
    "grapes": "🍇",
    "grasshopper": "🦗",
    "grateful": "🥲",
    "grave": "⚰",
    "graveyard": "🪦",
    "green": "🟢",
    "green_apple": "🍏",
    "green_book": "📗",
    "green_circle": "🟢",
    "green_heart": "💚",
    "green_large_square": "🟩",
    "grey_exclamation": "❕",
    "grey_question": "❔",
    "grimacing": "😬",
    "grinning": "😀",
    "grinning_face_with_smiling_eyes": "😁",
    "groan": "😮\u200d💨",
    "grow": "🪴",
    "growing": "📈",
    "growing_heart": "💗",
    "grumpy": "😡",
    "gua_pi_mao": "👲",
    "guanaco": "🦙",
    "guard": "💂",
    "guestrooms": "🛌",
    "guide": "🦮",
    "guide_dog": "🦮",
    "guitar": "🎸",
    "gun": "🔫",
    "gym": "🏋",
    "gymnastics": "🤸",
    "gyoza": "🥟",
    "gyōza": "🥟",
    "haircut": "💇",
    "half_frown": "😕",
    "halo": "😇",
    "hamburger": "🍔",
    "hammer": "🔨",
    "hammer_and_pick": "⚒",
    "hammer_and_wrench": "🛠",
    "hamsa": "🪬",
    "hamster": "🐹",
    "hand": "✋",
    "hand_gesture": "🤌",
    "hand_with_index_finger_and_thumb_crossed": "🫰",
    "handbag": "👜",
    "handball": "🤾",
    "handshake": "🤝",
    "handyman": "🔨",
    "handywoman": "🔨",
    "hang_glide": "🪂",
    "happy": "😀",
    "hard_hat": "⛑",
    "hard_of_hearing": "🦻",
    "harvest": "🌾",
    "hash": "#⃣",
    "hashi": "🥢",
    "hat": "👒",
    "hatchet": "🪓",
    "hatching": "🐣",
    "hatching_chick": "🐣",
    "haunted": "👻",
    "hazard": "☠",
    "hazy": "🌫",
    "head_bandage": "🤕",
    "head_in_clouds": "😶\u200d🌫",
    "heading_down": "⤵",
    "heading_up": "⤴",
    "headlines": "📰",
    "headphones": "🎧",
    "headscarf": "🧕",
    "headstone": "🪦",
    "health_worker": "🧑\u200d⚕",
    "healthier": "❤\u200d🩹",
    "hear": "🧏",
    "hear_no_evil": "🙉",
    "heart": "❤",
    "heart_arrow": "💘",
    "heart_box": "💟",
    "heart_exclamation": "❣",
    "heart_eyes": "😍",
    "heart_eyes_cat": "😻",
    "heart_hands": "🫶",
    "heart_kiss": "😘",
    "heart_of_gold": "💛",
    "heart_on_fire": "❤\u200d🔥",
    "heart_pulse": "💗",
    "heartache": "💔",
    "heartbeat": "💓",
    "hearts": "♥",
    "heat_stroke": "🥵",
    "heavy": "🪨",
    "heavy_equals_sign": "🟰",
    "hedgehog": "🦔",
    "helicopter": "🚁",
    "hello": "👋",
    "helmet": "⛑",
    "helpless": "😣",
    "herb": "🌿",
    "herd": "🦬",
    "here": "🈁",
    "hi": "👋",
    "hibiscus": "🌺",
    "hidden": "🥷",
    "hide": "🫥",
    "high_brightness": "🔆",
    "high_five": "🖐",
    "high_heels": "👠",
    "high_speed_train": "🚄",
    "high_voltage": "⚡",
    "hijab": "🧕",
    "hiking": "🥾",
    "hiking_boot": "🥾",
    "hindu": "🛕",
    "hindu_temple": "🛕",
    "hinduism": "🕉",
    "hint": "🗝",
    "hippo": "🦛",
    "hippopotamus": "🦛",
    "hiss": "🐍",
    "hocho": "🔪",
    "hoist": "🛗",
    "hold": "🧑\u200d🤝\u200d🧑",
    "holding_hands": "🧑\u200d🤝\u200d🧑",
    "hole": "🕳",
    "hole_in_one": "⛳",
    "holiday_tree": "🎄",
    "home_phone": "📞",
    "honey": "🍯",
    "honey_badger": "🦡",
    "honeybee": "🐝",
    "hongbao": "🧧",
    "hook": "🪝",
    "horizontal_traffic_light": "🚥",
    "horn": "📯",
    "horse": "🐎",
    "horse_racing": "🏇",
    "horse_riding": "🏇",
    "horseshoe": "🧲",
    "hospital": "🏥",
    "hot": "🔥",
    "hot_face": "🥵",
    "hot_pepper": "🌶",
    "hot_springs": "♨",
    "hotdog": "🌭",
    "hotel": "🏨",
    "hourglass": "⏳",
    "hourglass_done": "⌛",
    "house": "🏠",
    "houses": "🏘",
    "hover": "🕴",
    "hug": "🤗",
    "humpback_whale": "🐋",
    "hundred": "💯",
    "hungry": "🍽",
    "hurricane": "🌀",
    "hurt": "🤕",
    "hush": "🤐",
    "hushed": "😯",
    "hut": "🛖",
    "hygiene": "🪥",
    "hypnotized": "😵\u200d💫",
    "hóngbāo": "🧧",
    "ice": "🧊",
    "ice_cream": "🍨",
    "ice_cube": "🧊",
    "ice_hockey": "🏒",
    "ice_skate": "⛸",
    "iceberg": "🧊",
    "icicles": "🥶",
    "id": "🆔",
    "idea": "💡",
    "identification_card": "🪪",
    "ideograph_advantage": "🉐",
    "ill": "🤒",
    "ily": "🤟",
    "immigration": "🛂",
    "imp": "👿",
    "improving": "❤\u200d🩹",
    "in_bed": "🛌",
    "in_love": "😍",
    "inbox": "📥",
    "inbox_zero": "📭",
    "incognito": "🥸",
    "incorrect": "❌",
    "increase": "🔼",
    "increasing": "📈",
    "indecisive": "🧇",
    "index_pointing_at_the_viewer": "🫵",
    "infinity": "♾",
    "info": "ℹ",
    "information_desk_person": "💁",
    "inhalation": "🫁",
    "injection": "💉",
    "injured": "🤕",
    "injury": "🩸",
    "innocent": "😇",
    "intelligent": "🧠",
    "interlocking": "🧩",
    "interrobang": "⁉",
    "interrogation": "🤌",
    "intoxicated": "🥴",
    "introvert": "🫥",
    "invincible": "⛑",
    "invisible": "🫥",
    "iphone": "📱",
    "iron": "🧇",
    "islam": "☪",
    "island": "🏝",
    "izakaya_lantern": "🏮",
    "jack-o-lantern": "🎃",
    "jacket": "🧥",
    "japan": "🗾",
    "japan_post": "🏣",
    "japanese_acceptable_button": "🉑",
    "japanese_application_button": "🈸",
    "japanese_bargain_button": "🉐",
    "japanese_congratulations_button": "㊗",
    "japanese_discount_button": "🈹",
    "japanese_free_of_charge_button": "🈚",
    "japanese_here_button": "🈁",
    "japanese_monthly_amount_button": "🈷",
    "japanese_no_vacancy_button": "🈵",
    "japanese_not_free_of_charge_button": "🈶",
    "japanese_open_for_business_button": "🈺",
    "japanese_passing_grade_button": "🈴",
    "japanese_prohibited_button": "🈲",
    "japanese_reserved_button": "🈯",
    "japanese_secret_button": "㊙",
    "japanese_service_charge_button": "🈂",
    "japanese_vacancy_button": "🈳",
    "jar": "🫙",
    "jeans": "👖",
    "jeep": "🚙",
    "jiaozi": "🥟",
    "jigsaw": "🧩",
    "joey": "🦘",
    "joker": "🃏",
    "joking": "😜",
    "jolly_roger": "🏴\u200d☠",
    "joy": "😂",
    "joy_cat": "😹",
    "joystick": "🕹",
    "judaism": "✡",
    "judge": "🧑\u200d⚖",
    "juggling": "🤹",
    "jump": "🦘",
    "justice": "⚖",
    "kaaba": "🕋",
    "kaching": "🤑",
    "kale": "🥬",
    "kangaroo": "🦘",
    "kawaii": "💠",
    "keikogi": "🥋",
    "key": "🔑",
    "key_signing": "🔏",
    "keyboard": "⌨",
    "kick_scooter": "🛴",
    "kidney": "🫘",
    "kimono": "👘",
    "king": "👑",
    "kiss": "💏",
    "kiss_man_man": "👨\u200d❤\u200d💋\u200d👨",
    "kiss_smiling_eyes": "😙",
    "kiss_with_blush": "😚",
    "kiss_woman_man": "👩\u200d❤\u200d💋\u200d👨",
    "kiss_woman_woman": "👩\u200d❤\u200d💋\u200d👩",
    "kissing_cat": "😽",
    "kissing_face": "😗",
    "kite": "🪁",
    "kitten": "🐱",
    "kiwi": "🥝",
    "kneel": "🧎",
    "knife": "🔪",
    "knit": "🧶",
    "knot": "🪢",
    "koala": "🐨",
    "lab_coat": "🥼",
    "label": "🏷",
    "lacrosse": "🥍",
    "ladder": "🪜",
    "lady_beetle": "🐞",
    "ladybird": "🐞",
    "ladybug": "🐞",
    "lai_see": "🧧",
    "lambchop": "🥩",
    "lamp": "🪔",
    "landing": "🛬",
    "landline": "📞",
    "lantern": "🏮",
    "laptop": "💻",
    "large_blue_diamond": "🔷",
    "large_orange_diamond": "🔶",
    "last_quarter_moon": "🌗",
    "last_quarter_moon_face": "🌜",
    "lather": "🧼",
    "laughing": "😆",
    "laughter_tears": "😂",
    "laundry": "🧺",
    "lavash": "🫓",
    "lazy": "🦥",
    "leafy_green": "🥬",
    "leaves": "🍃",
    "ledger": "📒",
    "left": "⬅",
    "left_fist": "🤛",
    "left_hook": "↩",
    "left_right": "↔",
    "leftward": "🫲",
    "leftwards_hand": "🫲",
    "leg": "🦵",
    "legume": "🫘",
    "lemon": "🍋",
    "leo": "♌",
    "leopard": "🐆",
    "lets_eat": "🍽",
    "lettuce": "🥬",
    "level_slider": "🎚",
    "levitating": "🕴",
    "lgbtq": "🌈",
    "libra": "♎",
    "license": "🪪",
    "life": "🧬",
    "life_preserver": "🛟",
    "life_saver": "🛟",
    "lifestyles": "🛋",
    "lift": "🏋",
    "light": "🪶",
    "light_blue": "🏳️\u200d⚧️",
    "light_bulb": "💡",
    "light_rail": "🚈",
    "lightning": "🌩",
    "lightning_storm": "🌩",
    "like": "👍",
    "limb": "🦵",
    "link": "🔗",
    "linked": "🖇",
    "lion": "🦁",
    "lips": "👄",
    "lips_are_sealed": "🤐",
    "lipstick": "💄",
    "lipstick_kiss": "💋",
    "liquid": "🫠",
    "lit": "🔥",
    "live_long_and_prosper": "🖖",
    "living_room": "🛋",
    "lizard": "🦎",
    "llama": "🦙",
    "lobster": "🦞",
    "lock_with_key": "🔐",
    "locked": "🔒",
    "locked_bag": "🛅",
    "locker": "🛅",
    "log": "🪵",
    "lol": "😆",
    "lollipop": "🍭",
    "long_drum": "🪘",
    "looking": "👀",
    "loop": "➰",
    "losing_money": "💸",
    "lotion": "🧴",
    "lotion_bottle": "🧴",
    "lotus": "🪷",
    "louder": "🔊",
    "loudspeaker": "📢",
    "love": "❤",
    "love_hotel": "🏩",
    "love_letter": "💌",
    "love_you": "❤",
    "love_you_gesture": "🤟",
    "low_battery": "🪫",
    "low_brightness": "🔅",
    "low_energy": "🪫",
    "lower_left": "↙",
    "lower_right": "↘",
    "loyalty": "🔐",
    "lucky": "🍀",
    "luggage": "🧳",
    "lungs": "🫁",
    "lust": "❤\u200d🔥",
    "lying": "🤥",
    "m": "Ⓜ",
    "mad": "😡",
    "mage": "🧙",
    "maggot": "🪰",
    "magic": "🪄",
    "magic_wand": "🪄",
    "magnet": "🧲",
    "magnifying": "🔎",
    "magnifying_glass": "🔍",
    "magnifying_glass_tilted_right": "🔎",
    "mahjong": "🀄",
    "mail": "✉",
    "mail_dropoff": "📮",
    "mail_received": "📨",
    "mail_sent": "📩",
    "mailbox": "📫",
    "maintenance": "🔨",
    "maize": "🌽",
    "malaria": "🦟",
    "male_sign": "♂",
    "mammoth": "🦣",
    "man": "👨",
    "man_and_woman_couple": "👫",
    "man_and_woman_holding_hands": "👫",
    "man_artist": "👨\u200d🎨",
    "man_astronaut": "👨\u200d🚀",
    "man_bald": "👨\u200d🦲",
    "man_beard": "🧔\u200d♂",
    "man_biking": "🚴\u200d♂",
    "man_blond_hair": "👱\u200d♂",
    "man_bouncing_ball": "⛹️\u200d♂️",
    "man_bowing": "🙇\u200d♂",
    "man_cartwheeling": "🤸\u200d♂",
    "man_climbing": "🧗\u200d♂",
    "man_construction_worker": "👷\u200d♂",
    "man_cook": "👨\u200d🍳",
    "man_curly_hair": "👨\u200d🦱",
    "man_detective": "🕵️\u200d♂️",
    "man_elf": "🧝\u200d♂",
    "man_facepalming": "🤦\u200d♂",
    "man_factory_worker": "👨\u200d🏭",
    "man_fairy": "🧚\u200d♂",
    "man_farmer": "👨\u200d🌾",
    "man_feeding_baby": "👨\u200d🍼",
    "man_firefighter": "👨\u200d🚒",
    "man_frowning": "🙍\u200d♂",
    "man_genie": "🧞\u200d♂",
    "man_gesturing_no": "🙅\u200d♂",
    "man_gesturing_ok": "🙆\u200d♂",
    "man_getting_haircut": "💇\u200d♂",
    "man_getting_massage": "💆\u200d♂",
    "man_golfing": "🏌️\u200d♂️",
    "man_guard": "💂\u200d♂",
    "man_health_worker": "👨\u200d⚕",
    "man_in_lotus_position": "🧘\u200d♂",
    "man_in_manual_wheelchair": "👨\u200d🦽",
    "man_in_motorized_wheelchair": "👨\u200d🦼",
    "man_in_steamy_room": "🧖\u200d♂",
    "man_in_tuxedo": "🤵\u200d♂",
    "man_judge": "👨\u200d⚖",
    "man_juggling": "🤹\u200d♂",
    "man_kneeling": "🧎\u200d♂",
    "man_lifting_weights": "🏋️\u200d♂️",
    "man_mage": "🧙\u200d♂",
    "man_mechanic": "👨\u200d🔧",
    "man_mountain_biking": "🚵\u200d♂",
    "man_office_worker": "👨\u200d💼",
    "man_pilot": "👨\u200d✈",
    "man_playing_handball": "🤾\u200d♂",
    "man_playing_water_polo": "🤽\u200d♂",
    "man_police_officer": "👮\u200d♂",
    "man_pouting": "🙎\u200d♂",
    "man_raising_hand": "🙋\u200d♂",
    "man_red_hair": "👨\u200d🦰",
    "man_rowing_boat": "🚣\u200d♂",
    "man_running": "🏃\u200d♂",
    "man_scientist": "👨\u200d🔬",
    "man_shrugging": "🤷\u200d♂",
    "man_singer": "👨\u200d🎤",
    "man_standing": "🧍\u200d♂",
    "man_student": "👨\u200d🎓",
    "man_superhero": "🦸\u200d♂",
    "man_supervillain": "🦹\u200d♂",
    "man_surfing": "🏄\u200d♂",
    "man_swimming": "🏊\u200d♂",
    "man_teacher": "👨\u200d🏫",
    "man_technologist": "👨\u200d💻",
    "man_tipping_hand": "💁\u200d♂",
    "man_vampire": "🧛\u200d♂",
    "man_walking": "🚶\u200d♂",
    "man_wearing_turban": "👳\u200d♂",
    "man_white_hair": "👨\u200d🦳",
    "man_with_veil": "👰\u200d♂",
    "man_with_white_cane": "👨\u200d🦯",
    "man_zombie": "🧟\u200d♂",
    "mandarin": "🍊",
    "mango": "🥭",
    "mantelpiece_clock": "🕰",
    "mantilla": "🧕",
    "manual_wheelchair": "🦽",
    "map": "🗺",
    "maple_leaf": "🍁",
    "marsupial": "🦘",
    "martial_arts": "🥋",
    "mary": "🪬",
    "mask": "😷",
    "massage": "💆",
    "mate": "🧉",
    "math": "🟰",
    "mauritius": "🦤",
    "meal": "🍽",
    "meat": "🍖",
    "meatball": "🧆",
    "mechanic": "🧑\u200d🔧",
    "mechanical": "⚙",
    "mechanical_arm": "🦾",
    "mechanical_leg": "🦿",
    "medal": "🏅",
    "medical": "🩻",
    "medical_symbol": "⚕",
    "medicine": "💊",
    "megaphone": "📣",
    "meh": "🫤",
    "melon": "🍈",
    "melt": "🫠",
    "melted": "🫕",
    "melting_face": "🫠",
    "memo": "📝",
    "men_couple": "👬",
    "men_with_bunny_ears": "👯\u200d♂",
    "men_wrestling": "🤼\u200d♂",
    "mending": "❤\u200d🩹",
    "mending_heart": "❤\u200d🩹",
    "menorah": "🕎",
    "mens": "🚹",
    "menstruation": "🩸",
    "meow": "🐈",
    "mercy": "🥺",
    "mermaid": "🧜\u200d♀",
    "merman": "🧜\u200d♂",
    "merperson": "🧜",
    "merry_go_round": "🎠",
    "metal": "🪙",
    "meteor": "☄",
    "metro": "Ⓜ",
    "mexican": "🫔",
    "mic": "🎤",
    "microbe": "🦠",
    "microphone": "🎤",
    "microscope": "🔬",
    "middle_finger": "🖕",
    "mike": "🎤",
    "military": "🪖",
    "military_helmet": "🪖",
    "military_medal": "🎖",
    "milk": "🥛",
    "milky_way": "🌌",
    "mind_blown": "🤯",
    "mine": "⛏",
    "minibus": "🚐",
    "minidisc": "💽",
    "minus": "➖",
    "miriam": "🪬",
    "mirror": "🪞",
    "mirror_ball": "🪩",
    "mischievous": "😛",
    "mobile_phone": "📱",
    "mobility_aid": "🩼",
    "moisturizer": "🧴",
    "monarch": "🫅",
    "money": "💰",
    "money_face": "🤑",
    "money_with_wings": "💸",
    "monkey": "🐒",
    "monkey_face": "🐵",
    "monocle": "🧐",
    "monorail": "🚝",
    "monster": "🧌",
    "moon": "🌙",
    "moon_cake": "🥮",
    "moon_ceremony": "🎑",
    "moon_face": "🌝",
    "mortar": "🧱",
    "mortar_board": "🎓",
    "mosque": "🕌",
    "mosquito": "🦟",
    "mostly_sunny": "🌤",
    "mother_christmas": "🤶",
    "mother_nature": "🌬",
    "motor_bike": "🛵",
    "motor_boat": "🛥",
    "motorcycle": "🏍",
    "motorized_wheelchair": "🦼",
    "motorway": "🛣",
    "mount_fuji": "🗻",
    "mountain": "⛰",
    "mountain_biker": "🚵",
    "mountain_cableway": "🚠",
    "mountain_railway": "🚞",
    "mountain_sunrise": "🌄",
    "mouse": "🐁",
    "mouse_trap": "🪤",
    "mousetrap": "🪤",
    "mouth": "👄",
    "movie": "📽",
    "movie_camera": "🎥",
    "movie_theater": "🎦",
    "moving_truck": "🚚",
    "moyai": "🗿",
    "mrs_claus": "🤶",
    "multiplication": "✖",
    "multiply": "✖",
    "muscle": "💪",
    "mushroom": "🍄",
    "music": "🎵",
    "musical_keyboard": "🎹",
    "musical_notes": "🎶",
    "musical_score": "🎼",
    "mute": "🔇",
    "mute_notifications": "🔕",
    "mx_claus": "🧑\u200d🎄",
    "naan": "🫓",
    "nail_care": "💅",
    "nail_polish": "💅",
    "namaste": "🙏",
    "name_badge": "📛",
    "naruto": "🍥",
    "national_park": "🏞",
    "nauseated": "🤢",
    "navigation": "🧭",
    "nazar": "🧿",
    "nazar_amulet": "🧿",
    "nc17": "🔞",
    "neck": "🧣",
    "nerd": "🤓",
    "nervous": "😬",
    "nest_with_eggs": "🪺",
    "nesting_dolls": "🪆",
    "neutral": "😐",
    "new": "🆕",
    "new_baby": "🐥",
    "new_moon": "🌑",
    "new_moon_face": "🌚",
    "new_york": "🗽",
    "newspaper": "🗞",
    "next_track": "⏭",
    "ng": "🆖",
    "nib": "✒",
    "night": "🌃",
    "night_sky": "🌌",
    "nine": "9⃣",
    "ninja": "🥷",
    "no_bicycles": "🚳",
    "no_entry": "⛔",
    "no_mail": "📭",
    "no_mouth": "😶",
    "no_pedestrians": "🚷",
    "no_phones": "📵",
    "no_signal": "🙅",
    "no_smoking": "🚭",
    "no_sound": "🔇",
    "noble": "🫅",
    "non-potable_water": "🚱",
    "noodles": "🍜",
    "nope": "🙅",
    "north": "⬆",
    "north_east": "↗",
    "north_west": "↖",
    "nose": "👃",
    "not_allowed": "🚫",
    "note": "📝",
    "notebook": "📓",
    "notifications": "🔔",
    "nuclear": "☢",
    "number_one": "🥇",
    "numbers": "🔢",
    "nursery": "🚼",
    "nurturing": "🪴",
    "nut_and_bolt": "🔩",
    "o": "🅾",
    "ocean": "🌊",
    "ocean_sunrise": "🌅",
    "octagonal_sign": "🛑",
    "octopus": "🐙",
    "oden": "🍢",
    "offer": "🫴",
    "office": "🏢",
    "office_supplies": "🖇",
    "office_worker": "🧑\u200d💼",
    "ogre": "👹",
    "oh_no": "😕",
    "oil": "🪔",
    "oil_drum": "🛢",
    "oink": "🐖",
    "ok": "👌",
    "ok_signal": "🙆",
    "old": "🧓",
    "old_key": "🗝",
    "older_man": "👴",
    "older_person": "🧓",
    "older_woman": "👵",
    "olive": "🫒",
    "om": "🕉",
    "on": "🔛",
    "oncoming_automobile": "🚘",
    "oncoming_bus": "🚍",
    "oncoming_car": "🚘",
    "oncoming_police_car": "🚔",
    "oncoming_streetcar": "🚊",
    "oncoming_taxi": "🚖",
    "oncoming_train": "🚆",
    "oncoming_tram": "🚊",
    "oncoming_trolley": "🚊",
    "one": "1⃣",
    "one_piece": "🩲",
    "one_piece_swimsuit": "🩱",
    "onigiri": "🍙",
    "onion": "🧅",
    "oops": "🙃",
    "open_book": "📖",
    "open_hands": "👐",
    "open_mouth": "😮",
    "opening": "🪟",
    "ophiuchus": "⛎",
    "oracle": "🔮",
    "orange": "🍊",
    "orange_book": "📙",
    "orange_circle": "🟠",
    "orange_heart": "🧡",
    "orange_square": "🟧",
    "orangutan": "🦧",
    "organize": "📁",
    "orienteering": "🧭",
    "orthodox_cross": "☦",
    "ostentatious": "🦚",
    "otter": "🦦",
    "outbox": "📤",
    "overcast": "☁",
    "owl": "🦉",
    "ox": "🐂",
    "oyster": "🦪",
    "oyster_pail": "🥡",
    "p": "🅿",
    "package": "📦",
    "packing": "🧳",
    "pad": "🗓",
    "paella": "🥘",
    "page": "📄",
    "page_with_curl": "📃",
    "pager": "📟",
    "pail": "🪣",
    "pained": "😧",
    "paintbrush": "🖌",
    "painting": "🎨",
    "palette": "🎨",
    "palm": "🖐",
    "palm_down_hand": "🫳",
    "palm_tree": "🌴",
    "palm_up_hand": "🫴",
    "palms_up_together": "🤲",
    "pancakes": "🥞",
    "panda": "🐼",
    "pants": "🩳",
    "paper": "📄",
    "paper_towels": "🧻",
    "paperclip": "📎",
    "paperclip_chain": "🖇",
    "parachute": "🪂",
    "parasail": "🪂",
    "parasite": "🪱",
    "parking": "🅿",
    "parrot": "🦜",
    "part_alternation": "〽",
    "partly_cloudy": "⛅",
    "partly_sunny": "⛅",
    "partly_sunny_with_rain": "🌦",
    "party_ball": "🎊",
    "partying_face": "🥳",
    "pass": "🎫",
    "passenger_ship": "🛳",
    "passport_control": "🛂",
    "pastry": "🥧",
    "pause": "⏸",
    "paw_prints": "🐾",
    "paws": "🐾",
    "peace": "☮",
    "peace_sign": "✌",
    "peach": "🍑",
    "peacock": "🦚",
    "peahen": "🦚",
    "peanuts": "🥜",
    "pear": "🍐",
    "pedestrian": "🚶",
    "peep": "🫣",
    "pen": "🖊",
    "pencil": "✏",
    "penguin": "🐧",
    "pensive": "😔",
    "people_holding_hands": "🧑\u200d🤝\u200d🧑",
    "people_hugging": "🫂",
    "pepper": "🫑",
    "performing_arts": "🎭",
    "persevere": "😣",
    "person": "🧑",
    "person_bald": "🧑\u200d🦲",
    "person_beard": "🧔",
    "person_blond_hair": "👱",
    "person_climbing": "🧗",
    "person_curly_hair": "🧑\u200d🦱",
    "person_feeding_baby": "🧑\u200d🍼",
    "person_frowning": "🙍",
    "person_in_lotus_position": "🧘",
    "person_in_manual_wheelchair": "🧑\u200d🦽",
    "person_in_motorized_wheelchair": "🧑\u200d🦼",
    "person_in_steamy_room": "🧖",
    "person_kneeling": "🧎",
    "person_pouting": "🙎",
    "person_red_hair": "🧑\u200d🦰",
    "person_standing": "🧍",
    "person_tipping_hand": "💁",
    "person_white_hair": "🧑\u200d🦳",
    "person_with_crown": "🫅",
    "person_with_white_cane": "🧑\u200d🦯",
    "pester": "🦡",
    "petri_dish": "🧫",
    "petrol_pump": "⛽",
    "phone": "☎",
    "phone_off": "📴",
    "physics": "⚛",
    "piano": "🎹",
    "pick": "⛏",
    "pick_me": "🙋",
    "pick_up": "🛻",
    "picket": "🪧",
    "pickup": "🛻",
    "pickup_truck": "🛻",
    "picnic": "🧺",
    "picture": "🖼",
    "pie": "🥧",
    "piece": "🧩",
    "pierogi": "🥟",
    "pig": "🐖",
    "pig_nose": "🐽",
    "piglet": "🐷",
    "pile_of_poo": "💩",
    "pill": "💊",
    "pilot": "🧑\u200d✈",
    "pin": "📍",
    "pina_colada": "🥥",
    "pinata": "🪅",
    "pinched": "🤌",
    "pinched_fingers": "🤌",
    "pinching_hand": "🤏",
    "pineapple": "🍍",
    "ping_pong": "🏓",
    "pink": "🏳️\u200d⚧️",
    "pirate": "☠",
    "pirate_flag": "🏴\u200d☠",
    "pisces": "♓",
    "pita": "🫓",
    "pizza": "🍕",
    "piña_colada": "🥥",
    "piñata": "🪅",
    "placard": "🪧",
    "place_holder": "📑",
    "place_of_worship": "🛐",
    "plant": "🌿",
    "play": "▶",
    "play_pause": "⏯",
    "play_reverse": "◀",
    "playful": "🦦",
    "playground_slide": "🛝",
    "playing_cards": "🎴",
    "plaything": "🧸",
    "pleading_face": "🥺",
    "plumage": "🪶",
    "plunder": "🏴\u200d☠",
    "plunger": "🪠",
    "plus": "➕",
    "plush": "🧸",
    "point": "🫵",
    "point_down": "👇",
    "point_left": "👈",
    "point_of_information": "☝",
    "point_right": "👉",
    "point_up": "👆",
    "poison": "☠",
    "poker_face": "😶",
    "polar_bear": "🐻\u200d❄",
    "police": "👮",
    "police_car": "🚓",
    "pony": "🐴",
    "poodle": "🐩",
    "pool": "🎱",
    "poop": "💩",
    "popcorn": "🍿",
    "porkchop": "🥩",
    "porous": "🧽",
    "post_office": "🏤",
    "potable_water": "🚰",
    "potato": "🥔",
    "potsticker": "🥟",
    "potted_plant": "🪴",
    "pouch": "👝",
    "poultry": "🍗",
    "pound_notes": "💷",
    "pouring_liquid": "🫗",
    "pouting_cat": "😾",
    "pow": "💢",
    "power": "✊",
    "praise": "🙌",
    "pray": "🙏",
    "prayer": "🤲",
    "prayer_beads": "📿",
    "pregnant": "🤰",
    "pregnant_man": "🫃",
    "pregnant_person": "🫄",
    "present": "🎁",
    "pretzel": "🥨",
    "previous_track": "⏮",
    "price_tag": "🏷",
    "pride": "🌈",
    "prince": "🤴",
    "princess": "👸",
    "printer": "🖨",
    "privacy": "🔏",
    "prohibited": "🚫",
    "projector": "📽",
    "proof": "🧾",
    "prophecy": "🥠",
    "protected": "🔏",
    "protection": "🪬",
    "protest": "🪧",
    "puke": "🤮",
    "pulse": "🫀",
    "pumpkin": "🎃",
    "punch": "👊",
    "punk_rock": "🧷",
    "puppy": "🐶",
    "puppy_eyes": "🥺",
    "purity": "🪷",
    "purple_circle": "🟣",
    "purple_heart": "💜",
    "purple_square": "🟪",
    "purse": "👛",
    "push_pin": "📌",
    "put_litter_in_its_place": "🚮",
    "puzzle": "🧩",
    "puzzle_piece": "🧩",
    "queasy": "🤢",
    "queen": "👑",
    "quench": "🧯",
    "question": "❓",
    "quiet": "🤐",
    "r": "®",
    "rabbit": "🐇",
    "raccoon": "🦝",
    "race": "🏁",
    "racecar": "🏎",
    "radio": "📻",
    "radio_button": "🔘",
    "radioactive": "☢",
    "rage": "😡",
    "railway_car": "🚃",
    "railway_track": "🛤",
    "rainbow": "🌈",
    "rainbow_flag": "🏳\u200d🌈",
    "rainy": "🌧",
    "raised_hand": "✋",
    "raised_hands": "🙌",
    "raising_hand": "🙋",
    "ram": "🐏",
    "ramen": "🍜",
    "rat": "🐀",
    "rated_for_violence": "🗡",
    "razor": "🪒",
    "rebound": "🪃",
    "receipt": "🧾",
    "reception": "🛎",
    "record": "⏺",
    "recovering": "❤\u200d🩹",
    "recreational_vehicle": "🚙",
    "recuperating": "❤\u200d🩹",
    "recycle": "♻",
    "red": "🟥",
    "red_book": "📕",
    "red_circle": "🔴",
    "red_envelope": "🧧",
    "red_faced": "🥵",
    "red_square": "🟥",
    "red_triangle_down": "🔻",
    "red_triangle_up": "🔺",
    "reef": "🪸",
    "reflection": "🪞",
    "reflector": "🪞",
    "regal": "🫅",
    "registered": "®",
    "relaxed": "☺",
    "relief": "😮\u200d💨",
    "relieved": "😌",
    "reminder_ribbon": "🎗",
    "repeat": "🔁",
    "repeat_one": "🔂",
    "repercussion": "🪃",
    "reply": "↩",
    "rescue": "🛟",
    "rescue_worker": "⛑",
    "reserved": "🈯",
    "resist": "🥹",
    "respiration": "🫁",
    "restroom": "🚻",
    "return": "🔄",
    "revolving_hearts": "💞",
    "rewind": "⏪",
    "rhinoceros": "🦏",
    "rhythm": "🪘",
    "ribbon": "🎀",
    "rice": "🍚",
    "rice_cracker": "🍘",
    "rideshare": "🚕",
    "right": "➡",
    "right_fist": "🤜",
    "right_hook": "↪",
    "rightward": "🫱",
    "rightwards_hand": "🫱",
    "ring": "💍",
    "ring_buoy": "🛟",
    "ringed_planet": "🪐",
    "roach": "🪳",
    "road": "🛣",
    "road_trip": "🗺",
    "robot": "🤖",
    "rock": "🪨",
    "rock_carving": "🗿",
    "rock_on": "🤘",
    "rocket": "🚀",
    "rofl": "🤣",
    "roll_of_paper": "🧻",
    "roller": "🛼",
    "roller_coaster": "🎢",
    "roller_skate": "🛼",
    "rolling_eyes": "🙄",
    "rolling_on_the_floor_laughing": "🤣",
    "rolodex": "📇",
    "rooster": "🐓",
    "rope": "🪢",
    "rose": "🌹",
    "rosette": "🏵",
    "rotating_light": "🚨",
    "rotting": "🪰",
    "roundhouse": "🛖",
    "rowboat": "🚣",
    "rowing": "🚣",
    "royalty": "🫅",
    "rugby": "🏉",
    "ruler": "📏",
    "rung": "🪜",
    "runner": "🏃",
    "running": "🏃",
    "running_shirt": "🎽",
    "running_shoe": "👟",
    "russia": "🪆",
    "sacred_heart": "❤\u200d🔥",
    "sad": "☹",
    "safe": "🔐",
    "safety_first": "⛑",
    "safety_pin": "🧷",
    "safety_vest": "🦺",
    "sagittarius": "♐",
    "sailboat": "⛵",
    "sake": "🍶",
    "salad": "🥗",
    "salt": "🧂",
    "salute": "🫡",
    "saluting_face": "🫡",
    "sandal": "👡",
    "sandals": "🩴",
    "sandwich": "🥪",
    "santa": "🎅",
    "sarcastic": "🤌",
    "sari": "🥻",
    "satchel": "🎒",
    "satellite": "🛰",
    "satellite_antenna": "📡",
    "saturn": "🪐",
    "saturnine": "🪐",
    "sauce": "🫙",
    "sauropod": "🦕",
    "saw": "🪚",
    "saxophone": "🎷",
    "say_cheese": "📸",
    "scales": "⚖",
    "scared": "😨",
    "scarf": "🧣",
    "schmear": "🥯",
    "school": "🏫",
    "school_bus": "🚌",
    "school_crossing": "🚸",
    "science": "🔬",
    "scientist": "🧑\u200d🔬",
    "scissors": "✂",
    "scooter": "🛵",
    "scorpion": "🦂",
    "scorpius": "♏",
    "scream": "😱",
    "scream_cat": "🙀",
    "screw": "🔩",
    "screwdriver": "🪛",
    "scroll": "📜",
    "scuba": "🤿",
    "sculling": "🚣",
    "sea_lion": "🦭",
    "seafood": "🦞",
    "seal": "🦭",
    "sealed": "📩",
    "search": "🔍",
    "seashell": "🐚",
    "seat": "💺",
    "second_place": "🥈",
    "secret": "🗝",
    "secure": "🔐",
    "security": "🪪",
    "see_no_evil": "🙈",
    "seedling": "🌱",
    "seeing_stars": "💫",
    "selfie": "🤳",
    "selling_point": "🪝",
    "semi_truck": "🚛",
    "senbei": "🍘",
    "service": "🐕\u200d🦺",
    "service_charge": "🈂",
    "service_dog": "🐕\u200d🦺",
    "services": "🛎",
    "settings": "⚙",
    "seven": "7⃣",
    "sewing_needle": "🪡",
    "sewing_pin": "📍",
    "shadow": "👤",
    "shadows": "👥",
    "shaker": "🧂",
    "shampoo": "🧴",
    "shamrock": "☘",
    "shark": "🦈",
    "sharp": "🪒",
    "shave": "🪒",
    "shaved_ice": "🍧",
    "shawarma": "🥙",
    "sheep": "🐑",
    "shell": "🐚",
    "shield": "🛡",
    "shinto_shrine": "⛩",
    "ship": "🚢",
    "shiro": "🏯",
    "shirt": "👕",
    "shock": "😨",
    "shocked": "🤯",
    "shoe": "👞",
    "shoo": "🫳",
    "shooting_star": "🌠",
    "shopping_bags": "🛍",
    "shopping_cart": "🛒",
    "shopping_trolley": "🛒",
    "shorts": "🩳",
    "shout": "📣",
    "shower": "🚿",
    "shrimp": "🦐",
    "shrinking": "📉",
    "shrug": "🤷",
    "shuffle": "🔀",
    "shush": "🤫",
    "shushing_face": "🤫",
    "sick": "🤒",
    "sign": "🪧",
    "sign_of_the_horns": "🤘",
    "signal_bars": "📶",
    "signal_strength": "📶",
    "silence": "🤐",
    "silhouette": "👤",
    "silhouettes": "👥",
    "silver": "🥈",
    "singer": "🧑\u200d🎤",
    "siren": "🚨",
    "sit": "🪑",
    "six": "6⃣",
    "skate": "🛼",
    "skateboard": "🛹",
    "skeptic": "🤨",
    "skeptical": "🫤",
    "ski": "🎿",
    "ski_lift": "🚡",
    "skier": "⛷",
    "skip_back": "⏮",
    "skip_forward": "⏭",
    "skull": "💀",
    "skull_and_crossbones": "☠",
    "skunk": "🦨",
    "skydive": "🪂",
    "skyline": "🏙",
    "sled": "🛷",
    "sledge": "🛷",
    "sleeping": "😴",
    "sleepy": "😪",
    "sleigh": "🛷",
    "sleuth": "🕵",
    "slight_frown": "🙁",
    "slight_smile": "🙂",
    "slip_on": "🥿",
    "slipper": "🥿",
    "slot_machine": "🎰",
    "sloth": "🦥",
    "slow": "🦥",
    "sly": "🦝",
    "small": "🤪",
    "small_airplane": "🛩",
    "small_amount": "🤏",
    "small_blue_diamond": "🔹",
    "small_glass": "🥃",
    "small_orange_diamond": "🔸",
    "smartphone": "📱",
    "smile": "🙂",
    "smile_cat": "😸",
    "smiley": "😃",
    "smiley_cat": "😺",
    "smiling": "🥲",
    "smiling_devil": "😈",
    "smiling_face": "☺",
    "smiling_face_with_hearts": "🥰",
    "smiling_face_with_horns": "😈",
    "smiling_face_with_tear": "🥲",
    "smiling_imp": "😈",
    "smirk": "😏",
    "smirk_cat": "😼",
    "smitten": "💘",
    "smoking": "🚬",
    "smug": "😏",
    "smug_cat": "😼",
    "snail": "🐌",
    "snake": "🐍",
    "snap": "🫰",
    "snare": "🪤",
    "sneaker": "👟",
    "sneaky": "🕵",
    "sneezing": "🤧",
    "snorkeling": "🤿",
    "snowboarder": "🏂",
    "snowflake": "❄",
    "snowman": "☃",
    "snowstorm": "🌨",
    "snowy": "🌨",
    "snowy_mountain": "🏔",
    "soaked": "🌧",
    "soap": "🧼",
    "soapdish": "🧼",
    "soar": "🪁",
    "sob": "😭",
    "soccer": "⚽",
    "socks": "🧦",
    "soda": "🥤",
    "soft_ice_cream": "🍦",
    "soft_serve": "🍦",
    "softball": "🥎",
    "softer": "🔉",
    "soldier": "🪖",
    "solid": "🪨",
    "solidarity": "🎌",
    "soon": "🔜",
    "sort": "🗂",
    "sos": "🆘",
    "sound": "🔊",
    "soup": "🍲",
    "south": "⬇",
    "south_east": "↘",
    "south_west": "↙",
    "souvlaki": "🥙",
    "space_invader": "👾",
    "spades": "♠",
    "spaghetti": "🍝",
    "sparkle": "❇",
    "sparkler": "🎇",
    "sparkles": "✨",
    "sparkling_heart": "💖",
    "speak_no_evil": "🙊",
    "speaker": "🔈",
    "speaking_head": "🗣",
    "spectacles": "👓",
    "speculum": "🪞",
    "speech": "👁️\u200d🗨️",
    "speech_balloon": "💬",
    "speech_bubble": "🗨",
    "speechless": "😶",
    "speedboat": "🚤",
    "spider": "🕷",
    "spider_web": "🕸",
    "spill": "🫗",
    "spiny": "🦔",
    "spiral_calendar": "🗓",
    "spiral_notebook": "📒",
    "spiral_notepad": "🗒",
    "spiral_shell": "🐚",
    "split": "🪓",
    "spock": "🖖",
    "sponge": "🧽",
    "spooky": "👻",
    "spool": "🧵",
    "spoon": "🥄",
    "sports": "⛹",
    "spots": "🦒",
    "sprout": "🌱",
    "spy": "🕵",
    "squared_ok": "🆗",
    "squared_up": "🆙",
    "squeeze_box": "🪗",
    "squid": "🦑",
    "stadium": "🏟",
    "staff": "⚕",
    "stand": "🧍",
    "star": "⭐",
    "star_and_crescent": "☪",
    "star_of_david": "✡",
    "star_struck": "🤩",
    "stare": "🫣",
    "start": "🏁",
    "station": "🚉",
    "statue": "🗽",
    "statue_of_liberty": "🗽",
    "steak": "🥩",
    "stealth": "🥷",
    "steam_locomotive": "🚂",
    "step": "🪜",
    "stethoscope": "🩺",
    "stew": "🍲",
    "stink": "🦨",
    "stitches": "🪡",
    "stock_market": "💹",
    "stocking": "🧦",
    "stomp": "🦶",
    "stone": "🪨",
    "stop": "🤚",
    "stop_button": "⏹",
    "stop_sign": "🛑",
    "stopwatch": "⏱",
    "store": "🫙",
    "straightedge": "📏",
    "straw": "🧃",
    "strawberry": "🍓",
    "streetcar": "🚋",
    "stressed": "😥",
    "strike": "🎳",
    "string": "🧵",
    "stringed": "🪕",
    "stripe": "🦓",
    "striped_pole": "💈",
    "stuck_out_tongue": "😛",
    "stuck_out_tongue_closed_eyes": "😝",
    "stuck_out_tongue_wink": "😜",
    "student": "🧑\u200d🎓",
    "studio_microphone": "🎙",
    "stuffed": "🧸",
    "stuffed_flatbread": "🥙",
    "stuffy": "🧐",
    "subtract": "➖",
    "suburb": "🏡",
    "subway": "🚇",
    "suction": "🪠",
    "sun_and_rain": "🌦",
    "sun_face": "🌞",
    "sunflower": "🌻",
    "sunglasses": "😎",
    "sunny": "☀",
    "sunrise": "🌅",
    "sunscreen": "🧴",
    "sunset": "🌆",
    "sunshowers": "🌦",
    "superhero": "🦸",
    "supervillain": "🦹",
    "surf": "🏄",
    "surprise": "😮",
    "surrender": "🏳",
    "sushi": "🍣",
    "suspension_railway": "🚟",
    "sutures": "🪡",
    "swan": "🦢",
    "swap": "↔",
    "swat": "🗞",
    "swearing": "🤬",
    "sweat": "😓",
    "sweat_drops": "💦",
    "sweat_smile": "😅",
    "sweating": "🥵",
    "sweeping": "🧹",
    "sweet_potato": "🍠",
    "swim": "🏊",
    "swimming": "🥽",
    "swimsuit": "🩲",
    "swiss": "🫕",
    "swords": "⚔",
    "symbols": "🔣",
    "synagogue": "🕍",
    "syringe": "💉",
    "t_rex": "🦖",
    "table_setting": "🍽",
    "table_tennis": "🏓",
    "taco": "🌮",
    "tada": "🎉",
    "tag": "🏷",
    "tailoring": "🪡",
    "take_off": "🛫",
    "takeout_box": "🥡",
    "taking_a_picture": "📸",
    "talisman": "🧿",
    "talk": "🦜",
    "tamale": "🫔",
    "tanabata_tree": "🎋",
    "tangerine": "🍊",
    "tangled": "🪢",
    "tap_water": "🚰",
    "taurus": "♉",
    "taxi": "🚕",
    "tea": "🍵",
    "teacher": "🧑\u200d🏫",
    "teapot": "🫖",
    "tear": "🥲",
    "tears": "😂",
    "technologist": "🧑\u200d💻",
    "teddy_bear": "🧸",
    "teeth": "🪥",
    "telephone": "☎",
    "telescope": "🔭",
    "television": "📺",
    "temperature": "🌡",
    "temple": "🛕",
    "tempura": "🍤",
    "ten": "🔟",
    "tennis": "🎾",
    "tent": "⛺",
    "test_tube": "🧪",
    "thank_you": "🙏",
    "thanks": "🫂",
    "theater": "🎭",
    "thermometer": "🌡",
    "thinking": "🤔",
    "third_place": "🥉",
    "this": "👆",
    "thong_sandal": "🩴",
    "thong_sandals": "🩴",
    "thongs": "🩴",
    "thought": "💭",
    "thread": "🧵",
    "three": "3⃣",
    "thumb_tack": "📌",
    "thumbs_down": "👎",
    "thumbs_up": "👍",
    "thunder_and_rain": "⛈",
    "thunderstorm": "⛈",
    "tichel": "🧕",
    "ticket": "🎟",
    "tie": "👔",
    "tiger": "🐅",
    "tiger_cub": "🐯",
    "timber": "🪵",
    "time": "🕗",
    "time_ticking": "⏳",
    "timer": "⏲",
    "times_up": "⌛",
    "tipsy": "🥴",
    "tire": "🛞",
    "tired": "😔",
    "tm": "™",
    "toast": "🥂",
    "toilet": "🚽",
    "toilet_paper": "🧻",
    "tokyo_tower": "🗼",
    "tomato": "🍅",
    "tombstone": "🪦",
    "tongue": "👅",
    "toolbox": "🧰",
    "tools": "🛠",
    "tooth": "🦷",
    "toothbrush": "🪥",
    "top": "🔝",
    "top_hat": "🎩",
    "tornado": "🌪",
    "tortoise": "🐢",
    "touched": "🥲",
    "tower": "🗼",
    "toxic": "☠",
    "trackball": "🖲",
    "tractor": "🚜",
    "tractor-trailer": "🚛",
    "trademark": "™",
    "traffic_light": "🚦",
    "train": "🚂",
    "train_car": "🚃",
    "train_tracks": "🛤",
    "tram": "🚋",
    "transgender_flag": "🏳️\u200d⚧️",
    "transgender_symbol": "⚧",
    "transparent": "🪟",
    "transport_truck": "🚛",
    "trap": "🪤",
    "trash_can": "🗑",
    "travel": "🧳",
    "tree": "🌳",
    "triangular_flag": "🚩",
    "triangular_ruler": "📐",
    "trident": "🔱",
    "triton": "🧜\u200d♂",
    "triumph": "😤",
    "troll": "🧌",
    "trolley": "🚎",
    "troops": "🫡",
    "trophy": "🏆",
    "tropical_drink": "🍹",
    "tropical_fish": "🐠",
    "trouble": "😵\u200d💫",
    "truck": "🚛",
    "trumpet": "🎺",
    "tshirt": "👕",
    "tuk_tuk": "🛺",
    "tulip": "🌷",
    "tumbling": "🤸",
    "turban": "👳",
    "turkey": "🦃",
    "turn": "🛞",
    "turtle": "🐢",
    "tusk": "🦣",
    "tuxedo": "🤵",
    "tv": "📺",
    "twine": "🪢",
    "twist": "🪢",
    "twisted": "🥨",
    "two": "2⃣",
    "two_hearts": "💕",
    "two_men_holding_hands": "👬",
    "two_women_holding_hands": "👭",
    "typhoon": "🌀",
    "tyrannosaurus_rex": "🦖",
    "u5272": "🈹",
    "u5408": "🈴",
    "u55b6": "🈺",
    "u6708": "🈷",
    "u6709": "🈶",
    "u6e80": "🈵",
    "u7121": "🈚",
    "u7533": "🈸",
    "u7981": "🈲",
    "ufo": "👽",
    "ugly_duckling": "🦢",
    "ultimate": "🥏",
    "umbrella": "☂",
    "umbrella_with_rain": "☔",
    "umm": "💬",
    "unamused": "😒",
    "unbounded": "♾",
    "uncomfortable": "🫦",
    "underage": "🔞",
    "underarm": "🥎",
    "underwater": "🫧",
    "uneven_eyes": "🥴",
    "unicorn": "🦄",
    "universal": "♾",
    "unlocked": "🔓",
    "unlucky": "🐈\u200d⬛",
    "unread_mail": "📬",
    "unsure": "🫤",
    "up": "⬆",
    "up_button": "🔼",
    "up_down": "↕",
    "upper_left": "↖",
    "upper_right": "↗",
    "upside_down": "🙃",
    "upvote": "🔼",
    "upwards_trend": "📈",
    "useless": "🪴",
    "vacancy": "🈳",
    "vampire": "🧛",
    "vase": "🏺",
    "vat": "🪣",
    "vegetable": "🫑",
    "vertical_traffic_light": "🚦",
    "very_angry": "😡",
    "vest": "🦺",
    "vhs": "📼",
    "vibration_mode": "📳",
    "victory": "✌",
    "vicuna": "🦙",
    "vicuña": "🦙",
    "video_camera": "📹",
    "video_game": "🎮",
    "video_recorder": "📹",
    "videocassette": "📼",
    "view": "🪟",
    "violin": "🎻",
    "virgo": "♍",
    "vise": "🗜",
    "voicemail": "➿",
    "volcano": "🌋",
    "volleyball": "🏐",
    "volume": "🎚",
    "vomit": "🤮",
    "vs": "🆚",
    "waffle": "🧇",
    "wait_one_second": "☝",
    "walking": "🚶",
    "wall": "🧱",
    "waning_crescent_moon": "🌘",
    "waning_gibbous_moon": "🌖",
    "warm": "🌡",
    "warning": "⚠",
    "warrior": "🪖",
    "wastebasket": "🗑",
    "watch": "⌚",
    "water_buffalo": "🐃",
    "water_closet": "🚾",
    "water_drop": "💧",
    "water_polo": "🤽",
    "water_wave": "🌊",
    "watermelon": "🍉",
    "wave": "👋",
    "wavy_dash": "〰",
    "wavy_mouth": "🥴",
    "waxing": "🌒",
    "waxing_crescent_moon": "🌒",
    "waxing_moon": "🌔",
    "wc": "🚾",
    "weary": "😩",
    "weary_cat": "🙀",
    "web": "🕸",
    "wedding": "💒",
    "weight_lift": "🏋",
    "welcome": "🙏",
    "welding": "🥽",
    "well": "❤\u200d🩹",
    "west": "⬅",
    "whale": "🐳",
    "wheel": "🛞",
    "wheel_of_dharma": "☸",
    "wheelchair": "♿",
    "whisper": "😮\u200d💨",
    "whistle": "😮\u200d💨",
    "white_and_black_square": "🔲",
    "white_cane": "🦯",
    "white_circle": "⚪",
    "white_flag": "🏳",
    "white_flower": "💮",
    "white_heart": "🤍",
    "white_large_square": "⬜",
    "white_medium_small_square": "◽",
    "white_medium_square": "◻",
    "white_small_square": "▫",
    "whoa": "😵\u200d💫",
    "whoops": "🤭",
    "wild_cabbage": "🥦",
    "wilted_flower": "🥀",
    "wind": "🍃",
    "wind_chime": "🎐",
    "window": "🪟",
    "windy": "🌬",
    "wine": "🍷",
    "wink": "😉",
    "winner": "🏆",
    "wisent": "🦬",
    "wish": "🌠",
    "wish_tree": "🎋",
    "witness": "👁️\u200d🗨️",
    "wolf": "🐺",
    "woman": "👩",
    "woman_artist": "👩\u200d🎨",
    "woman_astronaut": "👩\u200d🚀",
    "woman_bald": "👩\u200d🦲",
    "woman_beard": "🧔\u200d♀",
    "woman_biking": "🚴\u200d♀",
    "woman_blond_hair": "👱\u200d♀",
    "woman_bouncing_ball": "⛹️\u200d♀️",
    "woman_bowing": "🙇\u200d♀",
    "woman_cartwheeling": "🤸\u200d♀",
    "woman_climbing": "🧗\u200d♀",
    "woman_construction_worker": "👷\u200d♀",
    "woman_cook": "👩\u200d🍳",
    "woman_curly_hair": "👩\u200d🦱",
    "woman_detective": "🕵️\u200d♀️",
    "woman_elf": "🧝\u200d♀",
    "woman_facepalming": "🤦\u200d♀",
    "woman_factory_worker": "👩\u200d🏭",
    "woman_fairy": "🧚\u200d♀",
    "woman_farmer": "👩\u200d🌾",
    "woman_feeding_baby": "👩\u200d🍼",
    "woman_firefighter": "👩\u200d🚒",
    "woman_frowning": "🙍\u200d♀",
    "woman_genie": "🧞\u200d♀",
    "woman_gesturing_no": "🙅\u200d♀",
    "woman_gesturing_ok": "🙆\u200d♀",
    "woman_getting_haircut": "💇\u200d♀",
    "woman_getting_massage": "💆\u200d♀",
    "woman_golfing": "🏌️\u200d♀️",
    "woman_guard": "💂\u200d♀",
    "woman_health_worker": "👩\u200d⚕",
    "woman_in_lotus_position": "🧘\u200d♀",
    "woman_in_manual_wheelchair": "👩\u200d🦽",
    "woman_in_motorized_wheelchair": "👩\u200d🦼",
    "woman_in_steamy_room": "🧖\u200d♀",
    "woman_in_tuxedo": "🤵\u200d♀",
    "woman_judge": "👩\u200d⚖",
    "woman_juggling": "🤹\u200d♀",
    "woman_kneeling": "🧎\u200d♀",
    "woman_lifting_weights": "🏋️\u200d♀️",
    "woman_mage": "🧙\u200d♀",
    "woman_mechanic": "👩\u200d🔧",
    "woman_mountain_biking": "🚵\u200d♀",
    "woman_office_worker": "👩\u200d💼",
    "woman_pilot": "👩\u200d✈",
    "woman_playing_handball": "🤾\u200d♀",
    "woman_playing_water_polo": "🤽\u200d♀",
    "woman_police_officer": "👮\u200d♀",
    "woman_pouting": "🙎\u200d♀",
    "woman_raising_hand": "🙋\u200d♀",
    "woman_red_hair": "👩\u200d🦰",
    "woman_rowing_boat": "🚣\u200d♀",
    "woman_running": "🏃\u200d♀",
    "woman_scientist": "👩\u200d🔬",
    "woman_shrugging": "🤷\u200d♀",
    "woman_singer": "👩\u200d🎤",
    "woman_standing": "🧍\u200d♀",
    "woman_student": "👩\u200d🎓",
    "woman_superhero": "🦸\u200d♀",
    "woman_supervillain": "🦹\u200d♀",
    "woman_surfing": "🏄\u200d♀",
    "woman_swimming": "🏊\u200d♀",
    "woman_teacher": "👩\u200d🏫",
    "woman_technologist": "👩\u200d💻",
    "woman_tipping_hand": "💁\u200d♀",
    "woman_vampire": "🧛\u200d♀",
    "woman_walking": "🚶\u200d♀",
    "woman_wearing_turban": "👳\u200d♀",
    "woman_white_hair": "👩\u200d🦳",
    "woman_with_headscarf": "🧕",
    "woman_with_veil": "👰\u200d♀",
    "woman_with_white_cane": "👩\u200d🦯",
    "woman_zombie": "🧟\u200d♀",
    "women_couple": "👭",
    "women_with_bunny_ears": "👯\u200d♀",
    "women_wrestling": "🤼\u200d♀",
    "womens": "🚺",
    "wood": "🪵",
    "woof": "🐕",
    "wool": "🦙",
    "woolly": "🦣",
    "woozy_face": "🥴",
    "work_in_progress": "🚧",
    "work_out": "🏋",
    "working_on_it": "🛠",
    "world_map": "🗺",
    "worm": "🪱",
    "worried": "😟",
    "wrapped": "🫔",
    "wrench": "🔧",
    "wrestling": "🤼",
    "writing": "✍",
    "wrong": "❌",
    "wrong_way": "⛔",
    "www": "🌐",
    "x": "❎",
    "x_ray": "🩻",
    "yacht": "🛳",
    "yam": "🍠",
    "yarn": "🧶",
    "yawn": "🥱",
    "yawning_face": "🥱",
    "yellow": "🟡",
    "yellow_circle": "🟡",
    "yellow_heart": "💛",
    "yellow_large_square": "🟨",
    "yen_banknotes": "💴",
    "yes": "🫡",
    "yin_yang": "☯",
    "yo_yo": "🪀",
    "you": "🫵",
    "young": "🧒",
    "yuebing": "🥮",
    "yum": "😋",
    "yurt": "🛖",
    "yuèbǐng": "🥮",
    "zany_face": "🤪",
    "zap": "⚡",
    "zebra": "🦓",
    "zero": "0⃣",
    "zip_it": "🤐",
    "zombie": "🧟",
    "zori": "🩴",
    "zzz": "💤",
    "zōri": "🩴",
    "ココ": "🈁",
    "サ": "🈂",
    "指": "🈯",
    "空": "🈳",
}
